/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.packets.AxiomClientboundResponseChunkData;
import com.moulberry.axiom.packets.AxiomServerboundPacket;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class AxiomServerboundRequestChunkData
implements AxiomServerboundPacket {
    public static final class_2960 IDENTIFIER = new class_2960("axiom:request_chunk_data");
    private final long id;
    private final class_5321<class_1937> world;
    private final LongSet blockEntities;
    private final LongSet chunkSections;
    private final boolean sendBlockEntitiesInChunks;

    public AxiomServerboundRequestChunkData(long id, class_5321<class_1937> world, LongSet blockEntities, LongSet chunkSections, boolean sendBlockEntitiesInChunks) {
        this.id = id;
        this.world = world;
        this.blockEntities = blockEntities;
        this.chunkSections = chunkSections;
        this.sendBlockEntitiesInChunks = sendBlockEntitiesInChunks;
    }

    public static AxiomServerboundRequestChunkData read(class_2540 friendlyByteBuf) {
        long id = friendlyByteBuf.readLong();
        class_5321 world = friendlyByteBuf.method_44112(class_7924.field_41223);
        boolean sendBlockEntitiesInChunks = friendlyByteBuf.readBoolean();
        LongOpenHashSet blockEntities = new LongOpenHashSet();
        int count = friendlyByteBuf.method_10816();
        for (int i = 0; i < count; ++i) {
            blockEntities.add(friendlyByteBuf.readLong());
        }
        LongOpenHashSet chunkSections = new LongOpenHashSet();
        count = friendlyByteBuf.method_10816();
        for (int i = 0; i < count; ++i) {
            chunkSections.add(friendlyByteBuf.readLong());
        }
        return new AxiomServerboundRequestChunkData(id, (class_5321<class_1937>)world, (LongSet)blockEntities, (LongSet)chunkSections, sendBlockEntitiesInChunks);
    }

    @Override
    public class_2960 id() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        LongIterator iterator;
        friendlyByteBuf.writeLong(this.id);
        friendlyByteBuf.method_44116(this.world);
        friendlyByteBuf.writeBoolean(this.sendBlockEntitiesInChunks);
        if (this.blockEntities == null) {
            friendlyByteBuf.method_10804(0);
        } else {
            friendlyByteBuf.method_10804(this.blockEntities.size());
            iterator = this.blockEntities.longIterator();
            while (iterator.hasNext()) {
                friendlyByteBuf.writeLong(iterator.nextLong());
            }
        }
        if (this.chunkSections == null) {
            friendlyByteBuf.method_10804(0);
        } else {
            friendlyByteBuf.method_10804(this.chunkSections.size());
            iterator = this.chunkSections.longIterator();
            while (iterator.hasNext()) {
                friendlyByteBuf.writeLong(iterator.nextLong());
            }
        }
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        int beforeWriterIndex;
        if (AxiomServerboundPacket.isMissingPermission(server, player)) {
            new AxiomClientboundResponseChunkData(this.id, true, (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), (Long2ObjectMap<class_2841<class_2680>>)new Long2ObjectOpenHashMap()).send(player);
            return;
        }
        class_3218 level = server.method_3847(this.world);
        if (level == null) {
            new AxiomClientboundResponseChunkData(this.id, true, (Long2ObjectMap<CompressedBlockEntity>)new Long2ObjectOpenHashMap(), (Long2ObjectMap<class_2841<class_2680>>)new Long2ObjectOpenHashMap()).send(player);
            return;
        }
        boolean warnedAboutNonExistant = false;
        Long2ObjectOpenHashMap blockEntityMap = new Long2ObjectOpenHashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LongIterator iterator = this.blockEntities.iterator();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        while (iterator.hasNext()) {
            long pos = iterator.nextLong();
            class_2586 blockEntity = level.method_8321((class_2338)mutableBlockPos.method_16363(pos));
            if (blockEntity != null) {
                class_2487 tag = VersionUtils.wasteSecond(blockEntity.method_38244(), server.method_30611());
                blockEntityMap.put(pos, (Object)CompressedBlockEntity.compress(tag, baos));
                continue;
            }
            if (warnedAboutNonExistant) continue;
            warnedAboutNonExistant = true;
            Axiom.LOGGER.warn("Client requested block entity data at {}, but block was {}", (Object)class_2338.method_10092((long)pos), (Object)level.method_8320((class_2338)mutableBlockPos.method_16363(pos)));
        }
        int playerSectionX = player.method_31477() >> 4;
        int playerSectionZ = player.method_31479() >> 4;
        Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
        iterator = this.chunkSections.iterator();
        while (iterator.hasNext()) {
            class_2818 chunk;
            int sectionIndex;
            long pos = iterator.nextLong();
            int sx = class_2338.method_10061((long)pos);
            int sy = class_2338.method_10071((long)pos);
            int sz = class_2338.method_10083((long)pos);
            int distance = Math.abs(playerSectionX - sx) + Math.abs(playerSectionZ - sz);
            if (distance > 128 || (sectionIndex = (chunk = level.method_8497(sx, sz)).method_31603(sy)) < 0 || sectionIndex >= chunk.method_32890()) continue;
            class_2826 section = chunk.method_38259(sectionIndex);
            if (section.method_38292()) {
                sections.put(pos, null);
                continue;
            }
            class_2841 container = section.method_12265();
            sections.put(pos, (Object)container);
            if (!this.sendBlockEntitiesInChunks || !section.method_19523(class_4970.class_4971::method_31709)) continue;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (!blockState.method_31709()) continue;
                        mutableBlockPos.method_10103(sx * 16 + x, sy * 16 + y, sz * 16 + z);
                        class_2586 blockEntity = chunk.method_12201((class_2338)mutableBlockPos, class_2818.class_2819.field_12859);
                        if (blockEntity == null) continue;
                        class_2487 tag = VersionUtils.wasteSecond(blockEntity.method_38244(), server.method_30611());
                        blockEntityMap.put(mutableBlockPos.method_10063(), (Object)CompressedBlockEntity.compress(tag, baos));
                    }
                }
            }
        }
        boolean firstPart = true;
        int maxSize = 1048512;
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeLong(this.id);
        for (Long2ObjectMap.Entry entry : blockEntityMap.long2ObjectEntrySet()) {
            beforeWriterIndex = buf.writerIndex();
            buf.writeLong(entry.getLongKey());
            ((CompressedBlockEntity)entry.getValue()).write(buf);
            if (buf.writerIndex() >= maxSize) {
                if (firstPart) {
                    Axiom.dbg("AxiomServerboundRequestChunkData - Warning: More than " + NumberFormat.getInstance().format(maxSize) + " bytes in a single part. Forcing send...");
                    buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    buf.writeBoolean(false);
                    new AxiomClientboundResponseChunkData(buf).send(player);
                    buf = new class_2540(Unpooled.buffer());
                    buf.writeLong(this.id);
                    continue;
                }
                int copiedSize = buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                buf.getBytes(beforeWriterIndex, copied);
                buf.writerIndex(beforeWriterIndex);
                buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                buf.writeBoolean(false);
                new AxiomClientboundResponseChunkData(buf).send(player);
                buf = new class_2540(Unpooled.buffer());
                buf.writeLong(this.id);
                buf.writeBytes(copied);
                firstPart = true;
                continue;
            }
            firstPart = false;
        }
        buf.writeLong(PositionUtils.MIN_POSITION_LONG);
        for (Long2ObjectMap.Entry entry : sections.long2ObjectEntrySet()) {
            beforeWriterIndex = buf.writerIndex();
            buf.writeLong(entry.getLongKey());
            class_2841 container = (class_2841)entry.getValue();
            if (container == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                ((class_2841)entry.getValue()).method_12325(buf);
            }
            if (buf.writerIndex() >= maxSize) {
                if (firstPart) {
                    Axiom.dbg("AxiomServerboundRequestChunkData - Warning: More than " + NumberFormat.getInstance().format(maxSize) + " bytes in a single part. Forcing send...");
                    buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    buf.writeBoolean(false);
                    new AxiomClientboundResponseChunkData(buf).send(player);
                    buf = new class_2540(Unpooled.buffer());
                    buf.writeLong(this.id);
                    buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                    continue;
                }
                int copiedSize = buf.writerIndex() - beforeWriterIndex;
                byte[] copied = new byte[copiedSize];
                buf.getBytes(beforeWriterIndex, copied);
                buf.writerIndex(beforeWriterIndex);
                buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                buf.writeBoolean(false);
                new AxiomClientboundResponseChunkData(buf).send(player);
                buf = new class_2540(Unpooled.buffer());
                buf.writeLong(this.id);
                buf.writeLong(PositionUtils.MIN_POSITION_LONG);
                buf.writeBytes(copied);
                firstPart = true;
                continue;
            }
            firstPart = false;
        }
        buf.writeLong(PositionUtils.MIN_POSITION_LONG);
        buf.writeBoolean(true);
        new AxiomClientboundResponseChunkData(buf).send(player);
    }

    public static void register() {
        AxiomServerboundPacket.register(IDENTIFIER, AxiomServerboundRequestChunkData::read);
    }
}

